% This file will be called by csf.m and similar psychophysical scripts from our lab.
% It has to be placed in the same directory as the script.
% The function relates monitor luminance to RGB value. As such, it has to be adapted for the monitor "in charge"!

% Latest update: November 5, 2021 by Nomdo Jansonius

% (c) Laboratory of Experimental Ophthalmology, University Medical Center Groningen, University of Groningen

function [R] = monitorfunctie(L)
% Input of this function is the desired luminance (range 0-200 cd/m2); output is an RGB value (0-255).

% Example of a simplified monitorfunctie.m that assumes the monitor luminance to be 0 cd/m2 for RGB < 60,
% 200 cd/m2 for RGB = 240, and linearly related to RGB for RGB values between 60 and 240.

if (L>200)
  R = 240
elseif (L<0)
  R = 60
else
  R = 60+L*180/200;
endif

end

% Note: RGB values outside 60-240 are not used for this specific monitorfunctie.m - the script that calls
% monitorfunctie.m should limit the range of L to 0-200!

% To calibrate a monitor for usage with csf.m, first search for the RGB value that results in a luminance
% of 200 cd/m2 (RGBmax). Next, measure the luminance for a series of RGB values below RGBmax and think up
% a function to describe the observed relationship between monitor luminance and RGB value.
